﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
/*JavaScript to control tab display for the tbipat_summary page.*/
var VIEW = {
	INSTRUMENT_HX: {
		nDEFAULT: 10,
		nSUMMARY: 11
	},
	SCHEDULE: {
		nDEFAULT: 20,
		nEVENT: 21,
		nNEW_INSTRUMENT: 22,
		nMODIFIED_INSTRUMENT: 23,
		nLOCK_COMPLETED: 24,
		nLOCK_INCOMPLETED: 25
	}
};

var fnDisplayView = function (nView) {
	bInstrumentReadOnly = true;

	switch (nView) {
		case VIEW.INSTRUMENT_HX.nDEFAULT:
			fnDisplayHideEverything();
			break;

	    case VIEW.INSTRUMENT_HX.nSUMMARY:
	        App.pnlSummaryEpisode.show();
	        App.pnlSummaryAdmin.show();
            App.pnlSummaryAdmin.tab.show();

			App.pnlInstrumentContainer.show();

			App.pnlInstruments.show();
			App.pnlInstruments.tab.show();

			App.pnlInstrumentReportContainer.show();
			App.pnlInstrumentReportContainer.tab.show();

			App.pnlInstrumentFormContainer.tab.hide();
			App.pnlInstrumentFormContainer.hide();

			App.pnlInstrumentTrendContainer.show();
			App.pnlInstrumentTrendContainer.tab.show();

			App.pnlInstrumentContainer.setActiveTab(App.pnlInstrumentReportContainer);

			/*hide...*/
			App.pnlOutcomes.tab.hide();
			App.pnlPlan.tab.hide();
			App.pnlNote.tab.hide();
			App.pnlMedicalHx.tab.hide();

			App.tpPatientSummary.setActiveTab(App.pnlInstruments);
			break;

		case VIEW.SCHEDULE.nDEFAULT:
			fnDisplayHideEverything();
			break;

		case VIEW.SCHEDULE.nEVENT: /*Schedule Event View: {Outcomes, Assessment/Plan, Note, Past Medical Hx}*/
			fnDisplayScheduleEvent();
			break;

		case VIEW.SCHEDULE.nNEW_INSTRUMENT:
			bInstrumentReadOnly = false;
			fnDisplayScheduleInstrument(0); /*Instrument and Trend*/
			break;

		case VIEW.SCHEDULE.nLOCK_INCOMPLETED:
			fnDisplayScheduleInstrument(0); /*Instrument and Trend*/
			break;

		case VIEW.SCHEDULE.nMODIFIED_INSTRUMENT:
			bInstrumentReadOnly = false;
			fnDisplayScheduleInstrument(1); /*Report, Instrument and Trend*/
			break;

		case VIEW.SCHEDULE.nLOCK_COMPLETED:
			fnDisplayScheduleInstrument(1); /*Report, Instrument and Trend*/
			break;

	}
}

var fnDisplayHideEverything = function () {
    App.pnlSummaryAdmin.hide();
    App.pnlSummaryAdmin.tab.hide();

	App.pnlInstruments.hide();
	App.pnlInstruments.tab.hide();

	App.pnlOutcomes.hide();
	App.pnlOutcomes.tab.hide();

	App.pnlPlan.hide();
	App.pnlPlan.tab.hide();

	App.pnlNote.hide();
	App.pnlNote.tab.hide();

	App.pnlMedicalHx.hide();
	App.pnlMedicalHx.tab.hide();

	App.tpPatientSummary.setActiveTab(App.pnlClear);

}

var fnDisplayScheduleInstrument = function (nState) {
    App.pnlSummaryEpisode.show();
    App.pnlSummaryAdmin.tab.show();

	App.pnlInstrumentContainer.show();

	App.pnlInstruments.show();
	App.pnlInstruments.tab.show();

	switch (nState) {
		case 0: /*new instrument*/
			/*HideTab "pnlInstrumentReportContainer"*/
			App.pnlInstrumentReportContainer.hide();
			App.pnlInstrumentReportContainer.tab.hide();

			/*ShowTabs pnlInstrumentFormContainer, pnlInstrumentTrendContainer*/
			App.pnlInstrumentFormContainer.show();
			App.pnlInstrumentFormContainer.tab.show();

			App.pnlInstrumentTrendContainer.show();
			App.pnlInstrumentTrendContainer.tab.show();
			App.pnlInstrumentContainer.setActiveTab(App.pnlInstrumentFormContainer);
			break;

		case 1:/*green check mark (one instrument was saved)*/
			/*lock (committed to TIU)*/
			/*ShowTabs pnlInstrumentReportContainer, pnlInstrumentFormContainer, pnlInstrumentTrendContainer*/
			App.pnlInstrumentReportContainer.show();
			App.pnlInstrumentReportContainer.tab.show();

			App.pnlInstrumentFormContainer.show();
			App.pnlInstrumentFormContainer.tab.show();

			App.pnlInstrumentTrendContainer.show();
			App.pnlInstrumentTrendContainer.tab.show();

			App.pnlInstrumentContainer.setActiveTab(App.pnlInstrumentReportContainer);
			break;
	}

	App.pnlOutcomes.tab.show();
	App.pnlPlan.tab.show();
	App.pnlNote.tab.show();
	App.pnlMedicalHx.tab.show();

	App.tpPatientSummary.setActiveTab(App.pnlInstruments);
}

var fnDisplayScheduleEvent = function () {
    App.pnlSummaryEpisode.show();
    App.pnlSummaryAdmin.tab.show();

	/*hide the instrument edit tab*/
	App.pnlInstruments.hide();
	App.pnlInstruments.tab.hide();

	/*show event edit tabs also just in case they are not visible*/
	/*App.pnlOutcomes.show();*/
	App.pnlOutcomes.tab.show();

	/*App.pnlPlan.show();*/
	App.pnlPlan.tab.show();

	/*App.pnlNote.show();*/
	App.pnlNote.tab.show();

	/*App.pnlMedicalHx.show();*/
	App.pnlMedicalHx.tab.show();

	App.tpPatientSummary.setActiveTab(App.pnlOutcomes);
}